/*
 * Decompiled with CFR 0.152.
 */
package view;

import app.PlotDataXY;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import util.Logger;
import view.PlotWindow;

public class PlotXY
extends JPanel {
    static Logger logger = Logger.getLogger();
    private static final long serialVersionUID = 1L;
    private double tmgn;
    private double bmgn;
    private double lmgn;
    private double rmgn;
    private List<PlotDataXY> myDataList;
    private Color[] ColorArray = new Color[]{Color.red, Color.blue, Color.darkGray, Color.cyan};
    private PlotWindow myPW;

    public PlotXY(PlotWindow pw, List<PlotDataXY> pdList) {
        logger.entry(4, "PlotXY.PlotXY");
        this.tmgn = 0.2;
        this.bmgn = 0.2;
        this.lmgn = 0.2;
        this.rmgn = 0.2;
        this.myPW = pw;
        this.myDataList = pdList;
        logger.exit(4, "PlotXY.PlotXY");
    }

    private Color getColor(int n) {
        Color result = this.ColorArray[n % 4];
        return result;
    }

    private void addXAxis(Graphics g) {
        int h = this.getHeight();
        int w = this.getWidth();
        g.drawLine((int)((double)w * this.lmgn), (int)((double)h * (1.0 - this.bmgn)), (int)((double)w * (1.0 - this.rmgn)), (int)((double)h * (1.0 - this.bmgn)));
    }

    private void addYAxis(Graphics g) {
        int h = this.getHeight();
        int w = this.getWidth();
        g.drawLine((int)((double)w * this.lmgn), (int)((double)h * (1.0 - this.bmgn)), (int)((double)w * this.lmgn), (int)((double)h * this.tmgn));
    }

    private void addCaption(Graphics g) {
        int l = g.getFontMetrics().stringWidth(this.myPW.getCaption());
        int h = g.getFontMetrics().getHeight();
        int x = this.getWidth() / 2 - l / 2;
        int y = (int)(15.0 + this.tmgn / 2.0 + (double)(h / 2));
        g.drawString(this.myPW.getCaption(), x, y);
    }

    private void addXLabel(Graphics g) {
        int l = g.getFontMetrics().stringWidth(this.myPW.getXLabel());
        int h = g.getFontMetrics().getHeight();
        int x = this.getWidth() / 2 - l / 2;
        int y = (int)((double)this.getHeight() * (1.0 - this.bmgn / 2.0) + (double)(h / 2));
        g.drawString(this.myPW.getXLabel(), x, y);
    }

    private void addYLabel(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        int l = g.getFontMetrics().stringWidth(this.myPW.getYLabel());
        int x = (int)((double)this.getWidth() * (this.lmgn / 3.0));
        int y = this.getHeight() / 2 + l / 2;
        AffineTransform trans = new AffineTransform();
        trans.translate(x, y);
        trans.quadrantRotate(3);
        g2.setTransform(trans);
        g2.drawString(this.myPW.getYLabel(), 0, 0);
        trans.quadrantRotate(-3);
        trans.translate(-x, -y);
        g2.setTransform(trans);
    }

    private void addXTicks(Graphics g) {
        for (double num : this.myPW.XNumberList) {
            g.drawLine(this.scaleX(num), this.scaleY(this.myPW.floorY), this.scaleX(num), this.scaleY(this.myPW.floorY) + 2);
            String s = String.valueOf(num);
            int tw = g.getFontMetrics().stringWidth(s);
            int th = g.getFontMetrics().getHeight();
            g.drawString(s, this.scaleX(num) - tw / 2, this.scaleY(this.myPW.floorY) + th);
        }
    }

    private void addYTicks(Graphics g) {
        for (Double num : this.myPW.YNumberList) {
            g.drawLine(this.scaleX(this.myPW.floorX), this.scaleY(num), this.scaleX(this.myPW.floorX) - 2, this.scaleY(num));
            String s = String.valueOf(num);
            double tw = g.getFontMetrics().stringWidth(s);
            double th = g.getFontMetrics().getHeight();
            g.drawString(s, (int)((double)this.scaleX(this.myPW.floorX) - tw - 10.0), (int)((double)this.scaleY(num) + th / 3.0));
        }
    }

    private void addValues(Graphics g) {
        int count = -1;
        Iterator<PlotDataXY> it = this.myDataList.iterator();
        while (it.hasNext()) {
            g.setColor(this.getColor(++count));
            boolean initial = true;
            double first = 0.0;
            PlotDataXY pd = it.next();
            for (double f : pd.DataMap.keySet()) {
                if (!initial) {
                    int x1 = this.scaleX(first);
                    int y1 = this.scaleY(pd.DataMap.get(first));
                    int x2 = this.scaleX(f);
                    int y2 = this.scaleY(pd.DataMap.get(f));
                    g.drawLine(x1, y1, x2, y2);
                }
                first = f;
                initial = false;
            }
        }
    }

    private int scaleX(double val) {
        double xval = val - this.myPW.floorX;
        double max = this.myPW.ceilX - this.myPW.floorX;
        double region = (double)this.getWidth() * (1.0 - (this.lmgn + this.rmgn));
        int res = (int)(region / max * xval + (double)this.getWidth() * this.lmgn);
        return res;
    }

    private int scaleY(double val) {
        double yval = val - this.myPW.floorY;
        double max = this.myPW.ceilY - this.myPW.floorY;
        double region = (double)this.getHeight() * (1.0 - (this.bmgn + this.tmgn));
        double delta = region / max * yval;
        double res = (double)this.getHeight() - delta - (double)this.getHeight() * this.bmgn;
        int ires = (int)res;
        return ires;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(Color.BLACK);
        this.addXAxis(g);
        this.addXLabel(g);
        this.addXTicks(g);
        this.addYAxis(g);
        this.addYLabel(g);
        this.addYTicks(g);
        this.addCaption(g);
        g.setColor(Color.RED);
        this.addValues(g);
        this.myPW.updateSize();
    }
}

